var $table;

$("document").ready(function () {
    $("#linkCatalogos").addClass("subdrop");
	$table = $('#tablaUsuarios');
	
	consultar();
	$("#btnNuevo").click(function(){ nuevo(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnActualizar").click(function(){ actualizar(); });
	$("#btnEliminar").click(function(){ eliminar(); });
	
});


function nuevo(){
	$("#btnGuardar").show();
	$("#btnActualizar").hide();
	$("#btnEliminar").hide();
	
	$("#modal_add_user").modal("show");	
}

function consultar(){
      
	var json_request = {
		tipoOperacion: "consultaUsuarios"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/catUsuarios.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp);
			    $table.dataTable().fnDestroy();
                $table.DataTable({
                    data: resp.datos,
                    dom: 'Bfrtip',
                    buttons: [{ extend: 'copy', text: 'Copiar' },
                    { extend: 'csv', text: 'Excel' },
                    { extend: 'print', text: 'Imprimir' }
                    ],
                    "language": JSON.parse(lenguaje),
                    "autoWidth": false,
                    columns: [
                        { "data": "nombre" },
                        { "data": "paterno" },
                        { "data": "materno" },
                        {
                            "data": "nid",
                            "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                                $(nTd).html("<span><a href='#' onclick='verDetalle(" + sData + ")'><i class='fa fa-check-square fa-2x' style='padding-left: 10px;'></i></a></span>");
                            }
                        }
                    ]
                });							
		},
		complete: function () {
			ajaxindicatorstop();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});
}

function guardar(){
	
	var vNombre = $("#txtNombre").val();
	var vPaterno = $("#txtPaterno").val();
	var vMaterno = $("#txtMaterno").val();
	var vCorreo = $("#txtCorreo").val();
	var vUsuario = $("#txtUsuario").val();
	var vContrasenia = $("#txtContrasenia").val();
	
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "guardarUsuario"            
            ,pNombre:vNombre
            ,pPaterno:vPaterno
            ,pMaterno:vMaterno
            ,pUsuario:vUsuario
            ,pContrasenia: vContrasenia
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../facturacion/dataAccess/catUsuarios.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#modal_add_user").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
				MessageBox(0, thrownError);
            }
        });
    }
}

function actualizar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	var vNombre = $("#txtNombre").val();
	var vPaterno = $("#txtPaterno").val();
	var vMaterno = $("#txtMaterno").val();
	var vCorreo = $("#txtCorreo").val();
	var vUsuario = $("#txtUsuario").val();
	var vContrasenia = $("#txtContrasenia").val();
	var vNidCliente = $("#ddlCliente").val();
	
    if(validaDatos()){
               
        var json_request = {
            tipoOperacion: "actualizarUsuario"
			,pNid:pNid
            ,pNombre:vNombre
            ,pPaterno:vPaterno
            ,pMaterno:vMaterno
            ,pUsuario:vUsuario
            ,pContrasenia: vContrasenia
        };
        
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../facturacion/dataAccess/catUsuarios.php",
            dataType: "json",
            async: true,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				MessageBox(resp.transaccion, resp.mensaje);							
            },
            complete: function () {
                ajaxindicatorstop();
				consultar();
				$("#modal_add_user").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
			    console.log(xhr);
			    console.log(ajaxOptions);
			    console.log(thrownError);
            }
        });
    }
}

function eliminar(){
	
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "El usurio será dado de baja del sistema";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  
			    var json_request = {
					tipoOperacion: "eliminarUsuario"
					,pNid:pNid
					,pEstado:"0"
				};
			  
			    $.ajax({
					type: "POST",
					data: json_request,
					url: "../facturacion/dataAccess/catUsuarios.php",
					dataType: "json",
					async: true,
					beforeSend: function () {
						ajaxindicatorstart();
					},
					success: function (resp) {     
						console.log(resp);
						MessageBox(resp.transaccion, resp.mensaje);							
					},
					complete: function () {
						ajaxindicatorstop();
						consultar();
						$("#modal_add_user").modal("hide");
					},
					error: function (xhr, ajaxOptions, thrownError) {
						MessageBox(0, "Error");
					}
				});
		
		  }
		});
}


function verDetalle(pNid){
	$("#btnGuardar").hide();
	$("#btnActualizar").show();
	$("#btnEliminar").show();

	$("#hfIdSeleccionado").val(pNid);
	
	var json_request = {
		tipoOperacion: "consultaUsuariosXnid"            
		,pNid:pNid
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/catUsuarios.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
			console.log(resp.datos);	
			$("#txtNombre").val(resp.datos[0].nombre);
			$("#txtPaterno").val(resp.datos[0].paterno);
			$("#txtMaterno").val(resp.datos[0].materno);			
			$("#txtUsuario").val(resp.datos[0].usuario);
			$("#txtContrasenia").val(resp.datos[0].contrasenia);
			
			
			
		},
		complete: function () {
			ajaxindicatorstop();
			$("#modal_add_user").modal("show");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			MessageBox(0, xhr.responseText);
		}
	});	
}

function MessageBox(pTransaccion, pMensaje){
	if(parseInt(pTransaccion) === 1){
		swal("Correcto...!!!", pMensaje, "success");
	}else{
		swal("No puede continuar...!!!", pMensaje, "error");
	}	
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
	var vNombre = $("#txtNombre").val();
	var vPaterno = $("#txtPaterno").val();
	var vMaterno = $("#txtMaterno").val();
	var vCorreo = $("#txtCorreo").val();
	var vUsuario = $("#txtUsuario").val();
	var vContrasenia = $("#txtContrasenia").val();
	
	if(vNombre.length === 0){
         $("#txtNombre").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vPaterno.length === 0){
        $("#txtPaterno").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vMaterno.length === 0){
         $("#txtMaterno").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(vUsuario.length === 0){
        $("#txtUsuario").addClass('campo-requerido');
        respuesta=false;
    }
	
	if(vContrasenia.length === 0){
        $("#txtContrasenia").addClass('campo-requerido');
        respuesta=false;
    }
	
	
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}



function revisaRolSeleccionado(pValor){
	if(parseInt(pValor) === 3){
		$("#divCliente").show();
	}else{
		$("#divCliente").hide();
	}
}