var $table;
var $tableServicios;

$("document").ready(function () {
    $("#linkReportes").addClass("subdrop");
	$table = $('#tablaDatos');
	$tableServicios = $('#tablaServicios');

	inicialiaValores();
	consultar();

});

function inicialiaValores(){
		
	$("#btnNuevo").click(function(){ ventanaNuevo(); });
	$("#btnFiltrar").click(function(){ ventanaFiltro(); });
	$("#btnGuardar").click(function(){ guardar(); });
	$("#btnConsultar").click(function(){ consultar(); });
	

	var today = new Date();

    var newdate = new Date();
    newdate.setDate(today.getDate() - 30);

    var ddA = newdate.getDate();
    var mmA = newdate.getMonth() + 1; //January is 0! 
    var yyyyA = newdate.getFullYear();


    var findate = new Date();
    findate.setDate(today.getDate());

    var dd = findate.getDate();
    var mm = findate.getMonth() + 1; //January is 0! 
    var yyyy = findate.getFullYear();
			
	//Iniciamos Fechas
	$('input[id$=txtFechaInicio]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
	
		//Iniciamos Fechas
	$('input[id$=txtFechaFin]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });

	
    $("#txtFechaInicio").val(ddA + '/' + mmA + '/' + yyyyA);
    $("#txtFechaFin").val(dd + '/' + mm + '/' + yyyy);

	$("#ddlTipoSistema").change(function () {
		consultaClientes();
	});

	$("#ddlTipoSistemaFiltro").change(function () {
		consultaClientesFiltros();
	});

	$("#ddlCliente").change(function () {
		consultaListaFacturas();
	});

	$("#ddlFacturas").change(function () {
		cargarDatosFactura();
	});

	
}

function ventanaNuevo(){
    $("#popupNuevaNota").modal("show");
}

function ventanaFiltro(){
	$("#popuFiltro").modal("show");	
}

function guardar(){

    var pNidCliente = $("#ddlCliente").val();
    var pNidSistema = $("#ddlTipoSistema").val();   
    var pComentarios = $("#txtComentarios").val();

	var vGuardoDetalle = true;
	var vGuardoRelacion = true;

    if(validaDatos()){
        var json_request = {
            tipoOperacion: "guardar"  
			,pNidEmpresa:"1"
			,pNidSistema:pNidSistema
            ,pNidCliente:pNidCliente			
			,pComentarios:pComentarios
        };
        
		console.log("-> Iniciamos guardar nota credio encanbezado");
        $.ajax({
            type: "POST",
            data: json_request,
            url: "../facturacion/dataAccess/notasCredito.php",
            dataType: "json",
            async: false,
            beforeSend: function () {
                ajaxindicatorstart();
            },
            success: function (resp) {             
				console.log("-> Response guardar nota credito");
				console.log(resp);

			   var vNidNota = resp.nid;
			   var vUuid =  $("#hfUuid").val(); //Uuid factura seleccionada
			   var vNidFactura = $("#hfIdFactura").val(); //Factura seleccionada

			   //SI ENCABEZADO INSERTO OK - SE INSERTAN LAS FACTURAS
			   if(parseInt(resp.transaccion)){				
					$("#tablaServicios tbody tr").each(function () {
							var vServicio = $(this).find("#hfNidServicio").val();
							var vMonto = $(this).find("#txtMonto").val();

							var json_request_detalle = {
								tipoOperacion: "guardarDetalle"  
								,vNidNota:vNidNota
								,pNidEmpresa:"1"
								,pNidSistema:pNidSistema
								,vNidFactura:vNidFactura			
								,vNidServicio:vServicio
								,vUuid:vUuid
								,pTotal:vMonto
							};
							console.log("-> Guardamos detalle nota credito");
							console.log(json_request_detalle);
							
							$.ajax({
								type: "POST",
								data: json_request_detalle,
								url: "../facturacion/dataAccess/notasCredito.php",
								dataType: "json",
								async: false,
								beforeSend: function () {
									ajaxindicatorstart();
								},
								success: function (resp) {  
									console.log(resp);           
									//MessageBox(resp.transaccion, resp.mensaje);	

									if(parseInt(resp.transaccion) === 0){
										vGuardoDetalle = false;
									}
								},
								complete: function () {
									ajaxindicatorstop();
								},
								error: function (xhr, ajaxOptions, thrownError) {
									console.log(xhr);
									console.log(ajaxOptions);
									console.log(thrownError);
								}
							});					
					});

					//SE GUARDA RELACION FACTURA
					if(vGuardoDetalle){
						var json_request_relacion = {
							tipoOperacion: "guardarRelacionNota"  
							,pNidEmpresa:"1"
							,pNidSistema:pNidSistema
							,vNidNota:vNidNota
							,vNidFactura:vNidFactura
							,vUuid:vUuid
						};
						console.log("-> Guardamos relacion nota credito");
						console.log(json_request_relacion);
						
						$.ajax({
							type: "POST",
							data: json_request_relacion,
							url: "../facturacion/dataAccess/notasCredito.php",
							dataType: "json",
							async: false,
							beforeSend: function () {
								ajaxindicatorstart();
							},
							success: function (resp) {  
								console.log(resp);           
								//MessageBox(resp.transaccion, resp.mensaje);	
								
								if(parseInt(resp.transaccion) === 0){
									vGuardoRelacion = false;
								}
							},
							complete: function () {
								ajaxindicatorstop();
							},
							error: function (xhr, ajaxOptions, thrownError) {
								console.log(xhr);
								console.log(ajaxOptions);
								console.log(thrownError);
							}
						});	
					}

					if(vGuardoDetalle && vGuardoRelacion){
						MessageBox(1, "Nota de credito insertada con exito");
					}else{
						MessageBox(0, "Problemas al insertar la nota de credito");
					}
			   }
            },
            complete: function () {
                ajaxindicatorstop();
                consultar();
                $("#popupNuevaNota").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
                console.log(xhr);
                console.log(ajaxOptions);
                console.log(thrownError);
            }
        });
    }
}

function validaDatos(){
	var respuesta=true;
    var mensaje="";
	
    var pNidCliente = $("#ddlCliente").val();
    var pNidSistema = $("#ddlTipoSistema").val();
    var pComentarios = $("#txtComentarios").val();
	

	if(parseInt(pNidCliente) < 0){
        $("#ddlCliente").addClass('campo-requerido');
        respuesta=false;
    }

    if(parseInt(pNidSistema) < 0){
        $("#ddlTipoSistema").addClass('campo-requerido');
        respuesta=false;
    }

	if(pComentarios.length === 0){
         $("#txtComentarios").addClass('campo-requerido');
        respuesta=false;
    }

	$("#tablaServicios tbody tr").each(function () {
		var vServicio = $(this).find("#spanServicio").text();
		var vMonto = $(this).find("#txtMonto").val();

			if(vMonto.length === 0){
				respuesta = false;
			}else{
				if(parseInt(vMonto < 1 )){
					respuesta = false;
				}
			}		
	});

		
	if(respuesta === false){		
		swal("No puede continuar...!!!", "Falta informacion por continuar", "error");
    }
    
    return respuesta;
}


function consultar(){
	
	
	var pFechaInicio = $("#txtFechaInicio").val();
	var pFechaFin = $("#txtFechaFin").val();
	var pTipoSistema = $("#ddlTipoSistemaFiltro").val();
	var pNidCliente = $("#ddlClienteFiltro").val();
	var pEstado = $("#ddlTimbrada").val();
      
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pFechaInicio:pFechaInicio
		,pFechaFin:pFechaFin
		,pTipoSistema:pTipoSistema
		,pNidCliente:pNidCliente
		,pEstado:pEstado
	};
	
	console.log("--> Parametros");
	console.log(json_request);
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
		    
		    console.log("CONSULTA NOTAS CREDITO");
		    console.log(resp);
						
			$table.DataTable().clear().draw();
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				searching:false,
				paging:false,
				buttons: [
					'excel', 'print'
				],			
				columns: [
					{ "data": "sistema" ,"width":"15%" },
					{ "data": "cliente","width":"30%" },
					{ "data": "fechaNota" },
					{
                        "data": "total",
						"width": "10%",
                        "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                            $(nTd).html("<span class='spanMoney'>" + currencyFormat(parseFloat(sData)) + "</span>");
                        }
                    },
					{ "data": "folioCfdi","width":"10%" },
					{
						"data": "nid",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vImpresa = oData.impresa;
							var vFolio = oData.folioCfdi;
							var vTipoSistema = oData.tipoSistema;

							if(vImpresa === 'NO'){
								
								$(nTd).html("<span><a class='btn btn-danger btn-sm' href='#' onclick='timbrarNota(" + sData + ","+ vTipoSistema +")'>Timbrar</a></span>");
							}else{
								$(nTd).html("<span><a class='btn btn-warning btn-sm' href='#' onclick='verNota(" + vFolio + ")'>PDF</a></span>");
							}
							
						}
					}			
				]
			});		
		},
		complete: function () {
			ajaxindicatorstop();	
			$("#popuFiltro").modal("hide");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function consultaClientes(){
    console.log("consultaClientes");

	var pNidSistema = $("#ddlTipoSistema").val();

    $('#ddlCliente').empty();
	var json_request = {
		tipoOperacion: "consultaClientes"            
		,pSistema:pNidSistema
	};

	$("#ddlCliente").append('<option value="-1">- TODOS -</option>');
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		success: function (resp) {   
		     console.log("Listado de clientes");
		     console.log(resp);
		     
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlCliente").append('<option value="'+ json.nid +'">'+ json.razonsocial +'</option>'); 
			}			
		}
	});
}


function consultaClientesFiltros(){

	var pNidSistema = $("#ddlTipoSistemaFiltro").val();

    $('#ddlClienteFiltro').empty();

	console.log(pNidSistema);
	var json_request = {
		tipoOperacion: "consultaClientes"
		,pSistema:pNidSistema
	};

	$("#ddlClienteFiltro").append('<option value="-1">- SELECCIONE -</option>'); 
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		success: function (resp) {     
			
			console.log(resp);
			
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];                 
				$("#ddlClienteFiltro").append('<option value="'+ json.nid +'">'+ json.razonsocial +'</option>');  
			}			
		}
	});
}

function consultaListaFacturas(){

	var pNidSistema = $("#ddlTipoSistema").val();
	var pCliente = $("#ddlCliente").val();

    $('#ddlFacturas').empty();
	var json_request = {
		tipoOperacion: "consultaFacturas"            
		,pSistema:pNidSistema
		,pCliente:pCliente
	};

	$("#ddlFacturas").append('<option value="-1">- SELECCIONE -</option>');
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlFacturas").append('<option value="'+ json.idFactura +'"> Folio: '+ json.folioCfdi + ' -  Serie: ' + json.serie +'</option>'); 
			}			
		}
	});
}

function cargarDatosFactura(){
	var pNidSistema = $("#ddlTipoSistema").val();
	var pCliente = $("#ddlCliente").val();
	var pNidFactura = $("#ddlFacturas").val();

	var json_request = {
		tipoOperacion: "consultaFacturas"            
		,pSistema:pNidSistema
		,pCliente:pCliente
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			console.log(resp);
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];	
				
				if(parseInt(json.idFactura) === parseInt(pNidFactura)){
					$("#hfIdServicio").val(json.idServicio);
					//$("#hfIdServicio").val(1868);
					$("#hfUuid").val(json.uuid);	
					$("#hfIdFactura").val(pNidFactura);	
					
					cargaServiciosFactura();
				}				
			}			
			
		}
	});
}

function cargaServiciosFactura(){
	var pNidSistema = $("#ddlTipoSistema").val();
	var pCliente = $("#ddlCliente").val();
	var pNidFactura = $("#ddlFacturas").val();

	var json_request = {
		tipoOperacion: "consultaFacturaServicios"            
		,pSistema:pNidSistema
		,pCliente:pCliente
		,pNidFactura:pNidFactura
	};

	console.log("-> Busca servicios de la factura");
	console.log(json_request);
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		success: function (resp) {  
			console.log(resp);

			$tableServicios.DataTable().clear().draw();
			$tableServicios.dataTable().fnDestroy();
			$tableServicios.DataTable({
				data: resp.datos,
				searching:false,
				paging:false,
				info:false,
				columns: [
					{
						"data": "claveServicio",
						"width": "30%",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vNdServicio = oData.idServicio;
							$(nTd).html("<input id='hfNidServicio' type='hidden' value='"+ vNdServicio +"'><span id='spanServicio'>AMA"+ sData +"</span>");
						}
					},
					{
                        "data": "total",
						"width": "30%",
                        "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                            $(nTd).html("<span class='spanMoney'>" + currencyFormat(parseInt(sData)) + "</span>");
                        }
                    },
					{
						"data": "idServicio",
						"width": "40%",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							$(nTd).html("<input type='text' id='txtMonto' class='form-control'></input>");
						}
					}			
				]
			});		
		}
	});
}


function verFacturas(pNidNota){
	$("#popupFacturas").modal("show");
}

function currencyFormat(num) {
	return '$' + num.toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
}

function timbrarNota(pNidNota, pTipoSistema){
	
	var mensaje = "La nota sera timbrada";	
	   swal({
		  title: "Esta seguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
				$("#popupTimbrar").modal("show");
				timbrarNotaCredito(1, pTipoSistema, pNidNota);
		  	}
		});
}

function sleep(ms) {
	return new Promise(resolve => setTimeout(resolve, ms));
  }


function verNota(pNidNota){
	window.open("../../test_soap/boveda/N_"+ pNidNota +".pdf");
}