var $table;

$("document").ready(function () {
    $("#linkReportes").addClass("subdrop");
	$table = $('#tablaDatos');
	inicialiaValores();
	
    consultar();

});


function ventanaFiltro(){
	$("#popuFiltro").modal("show");	
}

function consultar(){
	
	
	var pFechaInicio = $("#txtFechaInicio").val();
	var pFechaFin = $("#txtFechaFin").val();
	var pTipoSistema = $("#ddlTipoSistema").val();
	var pTipoFactura = $("#ddlTipoFactura").val();
	var pRfcReceptor = $("#ddlCliente").val();


	var json_request = {
		tipoOperacion: "consultar"
		,pFechaInicio:pFechaInicio  
		,pFechaFin:pFechaFin          
		,pTipoSistema:pTipoSistema
		,pTipoFactura:pTipoFactura
		,pRFCReceptor:pRfcReceptor
	};

	console.log(json_request);
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/consultarFacturas.php",
		dataType: "json",
		async: true,
		beforeSend: function () {
			ajaxindicatorstart();
		},
		success: function (resp) {             
					
			$table.DataTable().clear().draw();
			$table.dataTable().fnDestroy();
			$table.DataTable({
				data: resp.datos,
				searching:true,
				paging:false,			
				columns: [
					{ "data": "folio","width": "5%" },
					{ "data": "serie","width": "5%" },
					{ "data": "estado","width": "5%" },
					{ "data": "rfcReceptor","width": "15%" },
					{ "data": "receptor" },
					{ "data": "fechaEmision","width": "15%" },
					{
                        "data": "total",
						"width": "10%",
                        "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
                            $(nTd).html("<span class='spanMoney'>" + currencyFormat(parseFloat(sData)) + "</span>");
                        }
                    },
                    {
						"data": "factura_pdf",
						"width": "5%",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pathFile = "'" + sData + "'";
							$(nTd).html('<span><a class="btn btn-warning btn-sm" href="#" onclick="verArchivo(' + pathFile + ')">PDF</a></span>');
						}
					},
                    {
						"data": "factura_xml",
						"width": "5%",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var pathFile = "'" + sData + "'";
							$(nTd).html('<span><a class="btn btn-danger btn-sm" href="#" onclick="verArchivo(' + pathFile + ')">XML</a></span>');
						}
                    },
                    {
						"data": "folio",
						"width": "5%",
						"fnCreatedCell": function (nTd, sData, oData, iRow, iCol) {
							var vUuid ="'" + oData.uuid + "'";
							var vRfcEmisor ="'" + oData.rfcEmisor + "'";
							var vRfcReceptor ="'" + oData.rfcReceptor + "'";
							var vTotal="'" + oData.total + "'";
							var vFolioFactura="'" + oData.folioFactura	 + "'";
							var vSerie="'" + oData.serie + "'";
							var vTipoSistema="'" + oData.tipoSistema + "'";
							var vEstado = oData.estado;
							
							if(vEstado != "Vigente"){
								$(nTd).html('<span></span>');
							}else{								
								$(nTd).html('<span><a class="btn btn-secondary btn-sm" href="javascript:cancelarFactura(' + vUuid + ','+ vRfcEmisor +','+ vRfcReceptor +','+ vTotal +','+ vFolioFactura +','+ vSerie +','+ vTipoSistema +')">Cancelar</a></span>');
							}
														
						}
                    }					
				]
			});		
		},
		complete: function () {
			ajaxindicatorstop();
			$("#popuFiltro").modal("hide");	
		},
		error: function (xhr, ajaxOptions, thrownError) {
			console.log(xhr);
			console.log(ajaxOptions);
			console.log(thrownError);
		}
	});
}

function verArchivo(pUrl){
	console.log(pUrl);
	window.open("../../moversa/test_soap/" +pUrl);
}

function consultarPersonal(){
      $('#ddlPersonal').empty();
	var json_request = {
		tipoOperacion: "consultaXestado"            
		,pEstado:"1"
	};
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../moversa/dataAccess/catPersonal.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			
			$("#ddlPersonal").append('<option value="-1">- TODOS -</option>'); 
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlPersonal").append('<option value="'+ json.nid +'">'+ json.nombre +' ' + json.paterno + ' ' + json.materno +'</option>');                    
			}			
		}
	});
}

function inicialiaValores(){
		
	$("#btnFiltro").click(function(){ ventanaFiltro(); });
	$("#btnConsultar").click(function(){ consultar(); });

	var today = new Date();

    var newdate = new Date();
    newdate.setDate(today.getDate() - 30);

    var ddA = newdate.getDate();
    var mmA = newdate.getMonth() + 1; //January is 0! 
    var yyyyA = newdate.getFullYear();


    var findate = new Date();
    findate.setDate(today.getDate());

    var dd = findate.getDate();
    var mm = findate.getMonth() + 1; //January is 0! 
    var yyyy = findate.getFullYear();
			
	//Iniciamos Fechas
	$('input[id$=txtFechaInicio]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });
	
		//Iniciamos Fechas
	$('input[id$=txtFechaFin]').datetimepicker({
        format: 'd/m/Y',
        lang: 'es',
        mask: true,
        timepicker: false
    });

	
    $("#txtFechaInicio").val(ddA + '/' + mmA + '/' + yyyyA);
    $("#txtFechaFin").val(dd + '/' + mm + '/' + yyyy);

	$("#ddlTipoSistema").change(function () {
		consultaClientes();
	});
}

function consultaClientes(){

	var pNidSistema = $("#ddlTipoSistema").val();

    $('#ddlCliente').empty();
	var json_request = {
		tipoOperacion: "consultaClientes"            
		,pSistema:pNidSistema
	};

	$("#ddlCliente").append('<option value="-1">- TODOS -</option>');
	
	$.ajax({
		type: "POST",
		data: json_request,
		url: "../facturacion/dataAccess/notasCredito.php",
		dataType: "json",
		async: true,
		success: function (resp) {             
			for (var i = 0; i < resp.datos.length; i++) {
				var json = resp.datos[i];					
				$("#ddlCliente").append('<option value="'+ json.rfc +'">'+ json.razonsocial +'</option>'); 
			}			
		}
	});
}

function currencyFormat(num) {
	return '$' + num.toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
  }
  
  
function cancelarFactura(vUuid,vRfcEmisor,vRfcReceptor,vTotal,vFolioFactura,vSerie, vTipoSistema){
							
	var pNid = $("#hfIdSeleccionado").val();
	
	var mensaje = "La factura será cancelada";	
	   swal({
		  title: "Esta serguro(a)?",
		  text:mensaje,
		  icon: "warning",
		  buttons: true,
		  dangerMode: true,
		})
		.then((willDelete) => {
		  if (willDelete) {
			  cancelarFacturaEmision(vUuid,vRfcEmisor,vRfcReceptor,vTotal,vFolioFactura,vSerie, vTipoSistema);			   
		  }
		});
}